// ignore_for_file: file_names, avoid_print, must_be_immutable, avoid_function_literals_in_foreach_calls, use_key_in_widget_constructors, prefer_const_constructors

import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:goevent2/Api/Config.dart';
import 'package:goevent2/utils/color.dart';

class GalleryView extends StatefulWidget {
  List? list;
  GalleryView({this.list, Key? key}) : super(key: key);

  @override
  State<GalleryView> createState() => _GalleryViewState();
}

class _GalleryViewState extends State<GalleryView> {
  List eventList = [];

  @override
  void initState() {
    eventList = widget.list ?? [];

    print("!!!!!!!!!!!!!!!!" + eventList.toString());

    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: whiteColor,
      appBar: AppBar(
          centerTitle: true,
          leading: BackButton(color: blackColor),
          elevation: 0,
          backgroundColor: whiteColor,
          title: Text(
            "Gallery",
            style: TextStyle(
                fontFamily: "Gilroy Bold", fontSize: 16, color: blackColor),
          )),
      body: SingleChildScrollView(
        child: Column(
          children: [
            Padding(
                padding: const EdgeInsets.symmetric(horizontal: 12),
                child: GridView.builder(
                  gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                    crossAxisCount: 2,
                    mainAxisExtent: 150,
                    crossAxisSpacing: 5,
                    mainAxisSpacing: 5,
                  ),
                  itemCount: eventList.length,
                  shrinkWrap: true,
                  itemBuilder: (context, index) {
                    return GestureDetector(
                      onTap: () {
                        Navigator.push(context, MaterialPageRoute(builder: (_) {
                          return FullScreenImage(
                            imageUrl: Config.base_url + eventList[index],
                            tag: "generate_a_unique_tag",
                          );
                        }));
                      },
                      child: Hero(
                        child: ClipRRect(
                          borderRadius: BorderRadius.circular(12),
                          child: Image.network(
                            Config.base_url + eventList[index],
                            fit: BoxFit.fill,
                          ),
                        ),
                        tag: "generate_a_unique_tag",
                      ),
                    );
                  },
                ))
          ],
        ),
      ),
    );
  }
}

class FullScreenImage extends StatelessWidget {
  String? imageUrl;
  String? tag;

  FullScreenImage({this.imageUrl, this.tag});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.black87,
      body: GestureDetector(
        child: Center(
          child: Hero(
            tag: tag!,
            child: CachedNetworkImage(
              width: MediaQuery.of(context).size.width,
              fit: BoxFit.contain,
              imageUrl: imageUrl!,
            ),
          ),
        ),
        onTap: () {
          Navigator.pop(context);
        },
      ),
    );
  }
}
